<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Print Documentation for links-->
	<xsl:template name="printHyperLinks">
		<xsl:param name="element"></xsl:param>
		
			<xsl:variable name="hlinks" select="$element/Hyperlink"></xsl:variable>
			<xsl:if test="$hlinks">
	
			<xsl:variable name="p_name">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'hyperLink'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>

			<!-- Heading -->
			<p/>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr class="TableHeaderStyle">
			<td>
			<font size="+0">
			<b><xsl:value-of select="$p_name"/></b>
			</font>
			</td>
			</tr>
			</table>
			<br/>

			<xsl:for-each select="$hlinks">

			        
				<xsl:variable name="destination" select="key('all-by-id', @element)"></xsl:variable>

				<xsl:choose>
					<xsl:when test="string-length(string($destination)) &gt; 0">
        				<xsl:variable name="localName" select="local-name($destination)"></xsl:variable>

        				<xsl:variable name="to">
						<xsl:value-of select="$destination/@metaclass"></xsl:value-of>
						<xsl:value-of select="$destination/@type"></xsl:value-of>
					</xsl:variable>				

					<xsl:choose>
						<!-- HyperLink to Diagram -->
						<xsl:when test="$localName='Diagram'">
							<xsl:variable name="refDiagram">
								<xsl:call-template name="DiagramMapPath">
									<xsl:with-param name="element" select="$destination"></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="ref">
								<xsl:call-template name="RelPathResolver">
									<xsl:with-param name="element" select="$destination"></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="refpath">
								<xsl:text disable-output-escaping="yes">&lt;a href="</xsl:text><xsl:value-of select="$refDiagram"></xsl:value-of><xsl:text disable-output-escaping="yes">" onClick="javascript:window.open ('</xsl:text><xsl:value-of select="$ref"></xsl:value-of><xsl:text disable-output-escaping="yes">', 'classFrame')" TARGET="imageFrame"&gt;</xsl:text><xsl:value-of select="$destination/@name"></xsl:value-of><xsl:text>&lt;/a&gt;</xsl:text>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="string-length(string($refDiagram)) &gt; 0">
									<xsl:call-template name="getLocalizedResource">
										<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
										<xsl:with-param name="p1" select="$to"></xsl:with-param>
									<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="getLocalizedResource">
										<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
										<xsl:with-param name="p1" select="$to"></xsl:with-param>
										<xsl:with-param name="p2" select="$destination/@name"></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<!-- HyperLink to common element-->
						<xsl:otherwise>
							<xsl:variable name="ref">
								<xsl:call-template name="RelPathResolver">
									<xsl:with-param name="element" select="$destination"></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="refpath">
								<xsl:text disable-output-escaping="yes">&lt;a href="</xsl:text><xsl:value-of select="$ref"></xsl:value-of><xsl:text disable-output-escaping="yes">"&gt;</xsl:text><xsl:choose><xsl:when test="string-length($destination/@name) &gt; 0"><xsl:value-of select="$destination/@name"></xsl:value-of></xsl:when><xsl:otherwise><xsl:value-of select="$destination/@elementName"></xsl:value-of></xsl:otherwise></xsl:choose><xsl:text>&lt;/a&gt;</xsl:text>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="string-length(string($ref)) &gt; 0">
									<xsl:call-template name="getLocalizedResource">
										<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
										<xsl:with-param name="p1" select="$to"></xsl:with-param>
									<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="getLocalizedResource">
										<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
										<xsl:with-param name="p1" select="$to"></xsl:with-param>
										<xsl:with-param name="p2" select="$destination/@name"></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
			        </xsl:when>
				
				<xsl:otherwise>
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
					</xsl:call-template>
					<xsl:variable name="path" select="@externalPath"></xsl:variable>
					<a href="{$path}">
						<xsl:value-of select="$path"></xsl:value-of>
					</a>
				</xsl:otherwise>

				</xsl:choose>
				<br/>
			</xsl:for-each>
			</xsl:if>

	</xsl:template>

</xsl:stylesheet>
